/*
 * Decompiled with CFR 0.152.
 */
package com.exporso.standalone;

import com.exporso.exporter.ExportResult;
import com.exporso.exporter.Exporters;
import com.exporso.exporter.OutputFile;
import com.exporso.exporter.file.ExporsoIOUtils;
import com.exporso.standalone.AbstractController;
import com.exporso.standalone.ExporsoFX;
import com.exporso.standalone.Logger;
import com.exporso.standalone.Result;
import com.exporso.standalone.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.FlowPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.swing.filechooser.FileSystemView;

public class MainController
extends AbstractController {
    @FXML
    private TextField inputDirTextField;
    @FXML
    private TextField outputDirTextField;
    @FXML
    private Button stopButton;
    public static final AtomicBoolean extractionRunning = new AtomicBoolean(true);
    @FXML
    private TableView<Result> resultTable;
    @FXML
    private TableColumn<Result, String> statusCol;
    @FXML
    private TableColumn<Result, String> filenameCol;
    @FXML
    private TableColumn<Result, String> exceptionCol;
    private final ObservableList<Result> data = FXCollections.observableArrayList();
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Button extractButton;
    @FXML
    private Button openFileSelectionButton;
    @FXML
    private Button openOutputFolderSelectionButton;
    @FXML
    private Menu settingsMenu;
    private static final String PROCESSING_SUCCESS = "success";
    private static final String PROCESSING_FAILURE = "failure";
    private static final String PROCESSING_IGNORED = "ignored";
    private static final String RED = "#fea3aa";
    private static final String YELLOW = "#faf884";
    private static final String GREEN = "#baed91";
    private static final String RED_BORDER_STYLE = "-fx-border-color: #FF0000";

    private void changeLanguage(String locale) {
        try {
            Logger.info("MainController.changeLanguage");
            Stage stage = (Stage)this.resultTable.getScene().getWindow();
            this.resources = ResourceBundle.getBundle("bundle", new Locale(locale));
            Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getResource("/main.fxml"), (ResourceBundle)this.resources);
            stage.setTitle("Exporso");
            stage.setScene(new Scene(root, 800.0, 600.0));
            stage.show();
        }
        catch (Exception e) {
            Logger.error("MainController.changeLanguage", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    @FXML
    public void initialize() {
        try {
            Logger.info("MainController.initialize");
            this.statusCol.setCellValueFactory((Callback)new PropertyValueFactory("status"));
            this.statusCol.setCellFactory(column -> new TableCell<Result, String>(){

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    TableRow currentRow = this.getTableRow();
                    if (empty || item == null) {
                        this.setText(null);
                        this.setGraphic(null);
                        currentRow.setStyle(null);
                    } else {
                        this.setText(MainController.this.resources.getString(item.toString()));
                        if (Objects.equals(item, MainController.PROCESSING_SUCCESS)) {
                            currentRow.setStyle("-fx-background-color:#baed91");
                        } else if (Objects.equals(item, MainController.PROCESSING_IGNORED)) {
                            currentRow.setStyle("-fx-background-color:#faf884");
                        } else if (Objects.equals(item, MainController.PROCESSING_FAILURE)) {
                            currentRow.setStyle("-fx-background-color:#fea3aa");
                        }
                    }
                }
            });
            this.filenameCol.setCellValueFactory((Callback)new PropertyValueFactory("filename"));
            this.exceptionCol.setCellValueFactory((Callback)new PropertyValueFactory("exception"));
            this.resultTable.setItems(this.data);
        }
        catch (Exception e) {
            Logger.error("MainController.initialize", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    @FXML
    private void showSettingsDialog() {
        try {
            Logger.info("MainController.showSettingsDialog");
            ArrayList<String> choices = new ArrayList<String>();
            choices.add(this.resources.getString("toSeparateFolders"));
            choices.add(this.resources.getString("toSingleFolder"));
            ChoiceDialog dialog = new ChoiceDialog((Object)((String)choices.get(0)), choices);
            dialog.setTitle(this.resources.getString("export"));
            dialog.setHeaderText(null);
            dialog.setContentText(this.resources.getString("extractFiles"));
            Optional result = dialog.showAndWait();
            result.ifPresent(choice -> {
                if (Objects.equals(choice, choices.get(0))) {
                    Settings.extractionOption = Settings.EXTRACTION_OPTION.TO_SEPARATE_FOLDERS;
                    Logger.info("showSettingsDialog, changed to: TO_SEPARATE_FOLDERS");
                } else if (Objects.equals(choice, choices.get(1))) {
                    Settings.extractionOption = Settings.EXTRACTION_OPTION.TO_SINGLE_FOLDER;
                    Logger.info("showSettingsDialog, changed to: TO_SINGLE_FOLDER");
                }
            });
        }
        catch (Exception e) {
            Logger.error("MainController.showSettingsDialog", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    @FXML
    private void showLanguageDialog() {
        try {
            Logger.info("MainController.showLanguageDialog");
            ArrayList<String> choices = new ArrayList<String>();
            choices.add("English");
            choices.add("Polish");
            ChoiceDialog dialog = new ChoiceDialog((Object)((String)choices.get(0)), choices);
            dialog.setTitle(this.resources.getString("languages"));
            dialog.setHeaderText(null);
            dialog.setContentText(this.resources.getString("interfaceLanguage"));
            Optional result = dialog.showAndWait();
            result.ifPresent(choice -> {
                if (Objects.equals(choice, choices.get(0))) {
                    this.changeLanguage("en");
                    Settings.language = Settings.LANGUAGE.ENGLISH;
                    Logger.info("showLanguageDialog, changed to: ENGLISH");
                } else if (Objects.equals(choice, choices.get(1))) {
                    this.changeLanguage("pl");
                    Settings.language = Settings.LANGUAGE.POLISH;
                    Logger.info("showLanguageDialog, changed to: POLISH");
                }
            });
        }
        catch (Exception e) {
            Logger.error("MainController.showLanguageDialog", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    @FXML
    private void showAboutDialog() {
        try {
            Logger.info("MainController.showAboutDialog");
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle(this.resources.getString("about"));
            alert.setHeaderText("Exporso");
            FlowPane fp = new FlowPane();
            Label lbl = new Label(this.resources.getString("visitHomepage"));
            Hyperlink link = new Hyperlink("https://exporso.com");
            fp.getChildren().addAll((Object[])new Node[]{lbl, link});
            link.setOnAction(evt -> {
                try {
                    Logger.info("MainController.showAboutDialog.goToExporsoHomepage");
                    ExporsoFX.goToExporsoHomepage();
                }
                catch (Throwable e) {
                    Logger.error("MainController.showAboutDialog.goToExporsoHomepage");
                }
            });
            alert.getDialogPane().contentProperty().set((Object)fp);
            alert.showAndWait();
        }
        catch (Exception e) {
            Logger.error("MainController.showAboutDialog", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    @FXML
    private void openDocumentFileSelection(ActionEvent ae) {
        try {
            Logger.info("MainController.openDocumentFileSelection");
            Node source = (Node)ae.getSource();
            Window stage = source.getScene().getWindow();
            DirectoryChooser dirChooser = new DirectoryChooser();
            dirChooser.setTitle(this.resources.getString("selectDocumentFile"));
            dirChooser.setInitialDirectory(this.getDefaultDir());
            File selectedDir = dirChooser.showDialog(stage);
            if (selectedDir != null) {
                this.inputDirTextField.setText(selectedDir.getAbsolutePath());
                this.inputDirTextField.setStyle(null);
                Settings.inputDir = selectedDir;
                Logger.info("openDocumentFileSelection, changed to: " + selectedDir);
                this.data.clear();
            }
        }
        catch (Exception e) {
            Logger.error("MainController.openDocumentFileSelection", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    @FXML
    private void openOutputFolderSelection(ActionEvent ae) {
        try {
            Logger.info("MainController.openOutputFolderSelection");
            Node source = (Node)ae.getSource();
            Window stage = source.getScene().getWindow();
            DirectoryChooser dirChooser = new DirectoryChooser();
            dirChooser.setTitle(this.resources.getString("selectOutputFolder"));
            dirChooser.setInitialDirectory(this.getDefaultDir());
            File selectedDir = dirChooser.showDialog(stage);
            if (selectedDir != null) {
                this.outputDirTextField.setText(selectedDir.getAbsolutePath());
                this.outputDirTextField.setStyle(null);
                Settings.outputDir = selectedDir;
                this.data.clear();
            }
        }
        catch (Exception e) {
            Logger.error("MainController.openOutputFolderSelection", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    private File getDefaultDir() {
        File homeDir = FileSystemView.getFileSystemView().getHomeDirectory();
        File desktop = new File(homeDir.getAbsolutePath(), "Desktop");
        if (desktop.exists()) {
            return desktop;
        }
        return homeDir;
    }

    @FXML
    private void extract() {
        try {
            Logger.info("MainController.extract");
            ArrayList<String> errors = new ArrayList<String>();
            if (Settings.inputDir == null) {
                errors.add(this.resources.getString("notSelectedInput"));
                this.inputDirTextField.setStyle(RED_BORDER_STYLE);
            } else {
                int count = this.countSupportedFiles();
                if (count == 0) {
                    errors.add(this.resources.getString("incorrectInput"));
                    this.inputDirTextField.setStyle(RED_BORDER_STYLE);
                }
            }
            if (Settings.outputDir == null) {
                errors.add(this.resources.getString("notSelectedOutput"));
                this.outputDirTextField.setStyle(RED_BORDER_STYLE);
            } else if (this.countNotHiddenFiles(Settings.outputDir) > 0L) {
                errors.add(this.resources.getString("notEmptyOutput"));
                this.outputDirTextField.setStyle(RED_BORDER_STYLE);
            }
            if (errors.size() > 0) {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle(this.resources.getString("about"));
                alert.setHeaderText(null);
                alert.setContentText(String.join((CharSequence)System.lineSeparator(), errors));
                alert.showAndWait();
            } else {
                extractionRunning.set(true);
                this.setRunningAsync();
                this.data.clear();
                this.extractAsync();
            }
        }
        catch (Exception e) {
            Logger.error("extract", e);
            this.showErrorAlert(e.getMessage());
        }
    }

    private int countSupportedFiles() {
        int count = 0;
        block0: for (File file : ExporsoIOUtils.filesInDirectory((File)Settings.inputDir)) {
            for (String extension : Exporters.getSupportedExtensions()) {
                if (!file.getName().toLowerCase().endsWith(extension)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    private void extractAsync() {
        new Thread(() -> {
            try {
                AtomicInteger counter = new AtomicInteger();
                AtomicInteger success = new AtomicInteger();
                AtomicInteger ignored = new AtomicInteger();
                AtomicInteger error = new AtomicInteger();
                int allFilesCount = ExporsoIOUtils.filesInDirectory((File)Settings.inputDir).length;
                System.out.println("MainController.extract.SIZE = " + allFilesCount);
                for (File file : ExporsoIOUtils.filesInDirectory((File)Settings.inputDir)) {
                    if (!extractionRunning.get()) {
                        this.stoppedExtracting(counter, success, ignored, error);
                        return;
                    }
                    String fileExtension = ExporsoIOUtils.getFileExtension((String)file.getAbsolutePath().toLowerCase());
                    if (Exporters.getExporter((String)fileExtension) != null) {
                        Object errorMessage;
                        ExportResult exportResult = null;
                        String fileNameWithoutExtension = ExporsoIOUtils.getFileNameWithoutExtension((String)file.getName());
                        String extension = ExporsoIOUtils.getFileExtension((String)file.getName());
                        String outputDir = fileNameWithoutExtension + "_" + extension;
                        String outputPath = null;
                        String prefixForFiles = null;
                        if (Settings.extractionOption.equals((Object)Settings.EXTRACTION_OPTION.TO_SINGLE_FOLDER)) {
                            outputPath = Settings.outputDir.getAbsolutePath();
                            prefixForFiles = fileNameWithoutExtension + "_" + fileExtension + "_";
                        } else {
                            try {
                                outputPath = new File(Settings.outputDir.getAbsolutePath(), outputDir).getAbsolutePath();
                                Files.createDirectories(Paths.get(outputPath, new String[0]).normalize(), new FileAttribute[0]);
                            }
                            catch (IOException e) {
                                errorMessage = "Cannot create directory: " + outputPath;
                                Logger.error("MainController.extract " + (String)errorMessage, e);
                                exportResult = new ExportResult(false, (String)errorMessage, (String)errorMessage, new LinkedList());
                            }
                        }
                        if (exportResult == null) {
                            try {
                                exportResult = Exporters.getExporter((String)fileExtension).export((InputStream)new FileInputStream(file), file.getName());
                            }
                            catch (IOException e) {
                                errorMessage = "Cannot open file: " + outputPath;
                                Logger.error("MainController.extract " + (String)errorMessage, e);
                                exportResult = new ExportResult(false, (String)errorMessage, (String)errorMessage, new LinkedList());
                            }
                            String outputFileAbsolutePath = "";
                            try {
                                for (OutputFile outputFile : exportResult.getOutputFiles()) {
                                    outputFileAbsolutePath = prefixForFiles != null ? Paths.get(outputPath, prefixForFiles + outputFile.getFileName()).toAbsolutePath().toString() : Paths.get(outputPath, outputFile.getFileName()).toAbsolutePath().toString();
                                    ExporsoIOUtils.copyStreamToFileAndClose((InputStream)outputFile.getInputStream(), (String)outputFileAbsolutePath);
                                }
                            }
                            catch (IOException e) {
                                String errorMessage2 = "Cannot write to file: " + outputFileAbsolutePath;
                                Logger.error("MainController.extract " + errorMessage2, e);
                                exportResult = new ExportResult(false, errorMessage2, errorMessage2, new LinkedList());
                            }
                        }
                        if (exportResult.isSuccessful()) {
                            String message = String.format("%s: %d", this.resources.getString("numberOfFiles"), exportResult.getNumberOfFiles());
                            this.addResultsAsync(PROCESSING_SUCCESS, file.getName(), message, counter.get(), allFilesCount);
                            success.incrementAndGet();
                            Logger.info("extract_success " + file.getName());
                        } else {
                            this.addResultsAsync(PROCESSING_FAILURE, file.getName(), exportResult.getShortError(), counter.get(), allFilesCount);
                            error.incrementAndGet();
                            Logger.error("extract_failure " + file.getName() + " " + exportResult.getLongError());
                        }
                    } else {
                        this.addResultsAsync(PROCESSING_IGNORED, file.getName(), "Not supported file type", counter.get(), allFilesCount);
                        ignored.incrementAndGet();
                        Logger.info("extract_ignored " + file.getName());
                    }
                    counter.incrementAndGet();
                }
                this.onFinishExport(counter, success, ignored, error);
            }
            finally {
                extractionRunning.set(false);
                this.setFinishedAsync();
            }
        }).start();
    }

    private void stoppedExtracting(AtomicInteger counter, AtomicInteger success, AtomicInteger ignored, AtomicInteger error) {
        Logger.info("MainController.extract - stop");
        this.setFinishedAsync();
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle(this.resources.getString("executionAborded"));
            alert.setHeaderText(null);
            ArrayList<String> message = new ArrayList<String>();
            message.add(String.format(this.resources.getString("processedFiles"), counter.get()));
            if (success.get() == 1) {
                message.add(this.resources.getString("processedSuccess1"));
            } else {
                message.add(String.format(this.resources.getString("processedSuccess"), success.get()));
            }
            if (ignored.get() == 1) {
                message.add(this.resources.getString("processedIgnored1"));
            } else {
                message.add(String.format(this.resources.getString("processedIgnored"), ignored.get()));
            }
            if (error.get() == 1) {
                message.add(this.resources.getString("processedError1"));
            } else {
                message.add(String.format(this.resources.getString("processedError"), error.get()));
            }
            alert.setContentText(String.join((CharSequence)System.lineSeparator(), message));
            alert.showAndWait();
        });
    }

    private void onFinishExport(AtomicInteger counter, AtomicInteger success, AtomicInteger ignored, AtomicInteger error) {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle(this.resources.getString("completedSuccessfully"));
            alert.setHeaderText(null);
            ArrayList<String> message = new ArrayList<String>();
            message.add(String.format(this.resources.getString("processedFiles"), counter.get()));
            message.add(String.format(this.resources.getString("processedSuccess"), success.get()));
            message.add(String.format(this.resources.getString("processedIgnored"), ignored.get()));
            message.add(String.format(this.resources.getString("processedError"), error.get()));
            alert.setContentText(String.join((CharSequence)System.lineSeparator(), message));
            alert.showAndWait();
        });
    }

    private void setRunningAsync() {
        Platform.runLater(() -> {
            this.inputDirTextField.setStyle(null);
            this.outputDirTextField.setStyle(null);
            this.stopButton.setVisible(true);
            this.progressBar.setVisible(true);
            if (!this.extractButton.isDisable()) {
                this.extractButton.setDisable(true);
            }
            if (!this.openFileSelectionButton.isDisable()) {
                this.openFileSelectionButton.setDisable(true);
            }
            if (!this.openOutputFolderSelectionButton.isDisable()) {
                this.openOutputFolderSelectionButton.setDisable(true);
            }
            if (!this.settingsMenu.isDisable()) {
                this.settingsMenu.setDisable(true);
            }
        });
    }

    private void setFinishedAsync() {
        Platform.runLater(() -> {
            this.stopButton.setVisible(false);
            this.progressBar.setVisible(false);
            if (this.extractButton.isDisable()) {
                this.extractButton.setDisable(false);
            }
            if (this.openFileSelectionButton.isDisable()) {
                this.openFileSelectionButton.setDisable(false);
            }
            if (this.openOutputFolderSelectionButton.isDisable()) {
                this.openOutputFolderSelectionButton.setDisable(false);
            }
            if (this.settingsMenu.isDisable()) {
                this.settingsMenu.setDisable(false);
            }
        });
    }

    private void addResultsAsync(String result, String fileName, String message, int fileNumber, int allFilesCount) {
        this.setRunningAsync();
        Platform.runLater(() -> {
            this.data.add((Object)new Result(result, fileName, message));
            this.resultTable.scrollTo(this.data.size());
            this.progressBar.setProgress((double)fileNumber / (double)allFilesCount);
        });
    }

    @FXML
    private void stopExtraction() {
        Logger.info("MainController.stopExtraction");
        extractionRunning.set(false);
    }

    @FXML
    private void exitApp() {
        Logger.info("MainController.exitApp");
        extractionRunning.set(false);
        Stage stage = (Stage)this.resultTable.getScene().getWindow();
        stage.close();
        System.exit(0);
    }

    private long countNotHiddenFiles(File dir) {
        if (dir == null) {
            return 0L;
        }
        String[] files = dir.list();
        if (files == null) {
            return 0L;
        }
        return Arrays.stream(files).filter(fileName -> !fileName.startsWith(".")).count();
    }
}

