/*
 * Decompiled with CFR 0.152.
 */
package com.exporso.standalone;

import com.exporso.exporter.file.ExporsoIOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Logger {
    public static final String REPORT_FILE_NAME;
    public static final String EXPORSO_FOLDER_PATH;
    private static final ExecutorService EXECUTOR_SERVICE;

    private static String getAsString() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
        return now.format(formatter);
    }

    public static synchronized void info(String message) {
        EXECUTOR_SERVICE.execute(() -> {
            try {
                String messageToLog = String.format("INFO %s: %s %s", Logger.getAsString(), message, System.lineSeparator());
                System.out.print(messageToLog);
                ExporsoIOUtils.writeStringToFile((File)new File(REPORT_FILE_NAME), (String)messageToLog);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static synchronized void error(String message, Exception e) {
        Logger.error(message + " " + ExporsoIOUtils.exceptionToString((Exception)e));
    }

    public static synchronized void error(String message) {
        EXECUTOR_SERVICE.execute(() -> {
            try {
                String messageToLog = String.format("ERROR %s: %s %s", Logger.getAsString(), message, System.lineSeparator());
                System.out.print(messageToLog);
                ExporsoIOUtils.writeStringToFile((File)new File(REPORT_FILE_NAME), (String)messageToLog);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    static {
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(1);
        String homeDir = System.getProperty("user.home");
        EXPORSO_FOLDER_PATH = Paths.get(homeDir, ".exporso").toAbsolutePath().toString();
        String filename = "exporso_report_" + Logger.getAsString() + ".txt";
        REPORT_FILE_NAME = Paths.get(EXPORSO_FOLDER_PATH, filename).toAbsolutePath().toString();
    }
}

