/*
 * Decompiled with CFR 0.152.
 */
package com.exporso.standalone;

import com.exporso.standalone.EulaService;
import com.exporso.standalone.LicenseController;
import com.exporso.standalone.Logger;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class ExporsoFX
extends Application {
    public static final int LICENSE_WINDOW_WIDTH = 600;
    public static final int LICENSE_WINDOW_HEIGHT = 400;
    public static final int MAIN_WINDOW_WIDTH = 800;
    public static final int MAIN_WINDOW_HEIGHT = 600;
    private static AtomicReference<HostServices> hostServices = new AtomicReference();

    public static void main(String[] args) {
        ExporsoFX.launch((String[])args);
    }

    public void start(Stage primaryStage) throws IOException {
        hostServices.set(this.getHostServices());
        Logger.info("Exporso.start - reading license");
        boolean eulaAccepted = EulaService.eulaAccepted();
        Logger.info(String.format("Exporso start - eulaAccepted=%s", eulaAccepted));
        if (eulaAccepted) {
            Logger.info("Exporso.start - eula accepted");
            LicenseController.showMainWindow(primaryStage);
        } else {
            Logger.info("Exporso.start - eula not accepted");
            this.loadLicenseWindow(primaryStage);
        }
    }

    private void loadLicenseWindow(Stage primaryStage) throws IOException {
        ResourceBundle bundle = ResourceBundle.getBundle("bundle");
        Parent root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/license.fxml"), (ResourceBundle)bundle);
        primaryStage.getIcons().add((Object)new Image(ExporsoFX.class.getResourceAsStream("/exporso.png")));
        primaryStage.setTitle("Exporso");
        primaryStage.setScene(new Scene(root, 600.0, 400.0));
        primaryStage.setMinWidth(600.0);
        primaryStage.setMinHeight(400.0);
        primaryStage.show();
    }

    public static void goToExporsoHomepage() {
        Optional.ofNullable(hostServices.get()).ifPresent(x -> x.showDocument("https://exporso.com"));
    }
}

