/*
 * Decompiled with CFR 0.152.
 */
package com.exporso.standalone;

import com.exporso.exporter.file.ExporsoIOUtils;
import com.exporso.standalone.Logger;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.time.Instant;

public class EulaService {
    private static final String EULA_FILE_PATH = Paths.get(Logger.EXPORSO_FOLDER_PATH, "exporso.eula").toAbsolutePath().toString();
    private static final String EULA_FILE = "exporso.eula";
    private static final String EULA_ACCEPTED = "eula accepted, date=%s";

    public static synchronized void acceptEula() {
        try (PrintWriter out = new PrintWriter(EULA_FILE_PATH);){
            String eulaAccepted = String.format(EULA_ACCEPTED, Instant.now().toString());
            out.println(eulaAccepted);
            out.flush();
        }
        catch (Exception e) {
            Logger.error("LicenseService.acceptEula exception", e);
            e.printStackTrace();
        }
    }

    public static synchronized boolean eulaAccepted() {
        try {
            return ExporsoIOUtils.fileExists((String)EULA_FILE_PATH);
        }
        catch (Exception e) {
            Logger.error("LicenseService.eulaAccepted exception", e);
            e.printStackTrace();
            return false;
        }
    }
}

